package app.firezone.synk.network.Activities;

import android.app.Dialog;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.util.Log;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Toast;


import androidx.appcompat.app.AppCompatActivity;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivityCashupiBinding;
import app.firezone.synk.network.model.ApiResponse;
import app.firezone.synk.network.model.TransactionModel;
import app.firezone.synk.network.model.User;


import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import app.firezone.synk.network.model.UserResponse;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;


public class CashupiActivity extends AppCompatActivity {

    private ActivityCashupiBinding binding;

    private Long currentCoin, currentDepo;

    String userToken;

    MyApi myApi;

    long userId ;

    private String amount, phoneno, transactionId, email;
    private Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        binding = ActivityCashupiBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        loadData();

        userId = SharedPrefManager.getInstance(this).getUserId();

        // Retrieve values from intent
        amount = getIntent().getStringExtra("amount");
        phoneno = getIntent().getStringExtra("Phoneno");
        userToken = getIntent().getStringExtra("apiKey");

        // Initialize loading dialog
        dialog = new Dialog(this);
        dialog.setContentView(R.layout.loading_dialog);
        dialog.show();
        if (dialog.getWindow() != null) {
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(false);
        }

        // Generate a unique transaction ID
        transactionId = "TRAN" + System.currentTimeMillis();

        // Create an order
        String orderId = "Order" + System.currentTimeMillis();
        createOrder(amount, orderId, phoneno);
    }

    private void createOrder(String amount, String orderId, String phoneno) {
        // Execute the API task
        new OrderApiTask().execute(
                phoneno,
                userToken,  // User API token
                amount,
                orderId,
                "https://cashupi.com/success",  // Redirect URL
                "Production",                  // Remark1
                getString(R.string.app_name)   // Remark2
        );
    }

    // AsyncTask to call the API
    private class OrderApiTask extends AsyncTask<String, Void, String> {

        @Override
        protected String doInBackground(String... params) {
            try {
                // API Endpoint
                URL url = new URL("https://cashupi.com/api/create-order");

                // Forming the request body
                String postData = "customer_mobile=" + URLEncoder.encode(params[0], "UTF-8") +
                        "&user_token=" + URLEncoder.encode(params[1], "UTF-8") +
                        "&amount=" + URLEncoder.encode(params[2], "UTF-8") +
                        "&order_id=" + URLEncoder.encode(params[3], "UTF-8") +
                        "&redirect_url=" + URLEncoder.encode(params[4], "UTF-8") +
                        "&remark1=" + URLEncoder.encode(params[5], "UTF-8") +
                        "&remark2=" + URLEncoder.encode(params[6], "UTF-8");

                // Opening Connection
                HttpURLConnection conn = (HttpURLConnection) url.openConnection();
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                conn.getOutputStream().write(postData.getBytes());

                // Get Response
                BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder response = new StringBuilder();
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();

                return response.toString();

            } catch (Exception e) {
                Log.e("OrderApiTask", "Error in API call", e);
                return null;
            }
        }

        @Override
        protected void onPostExecute(String result) {
            super.onPostExecute(result);

            dialog.dismiss();

            if (result != null) {
                try {
                    JSONObject jsonResponse = new JSONObject(result);

                    if (jsonResponse.getBoolean("status")) {
                        JSONObject resultObject = jsonResponse.getJSONObject("result");
                        String orderId = resultObject.getString("orderId");
                        String paymentUrl = resultObject.getString("payment_url");

                        WebView webView = findViewById(R.id.webViewPayment);
                        WebSettings webSettings = webView.getSettings();
                        webSettings.setJavaScriptEnabled(true);
                        webSettings.setDomStorageEnabled(true);
                        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
                        webSettings.setSupportMultipleWindows(true);

                        webView.setWebViewClient(new WebViewClient() {
                            @Override
                            public void onPageFinished(WebView view, String url) {
                                super.onPageFinished(view, url);
                                Toast.makeText(CashupiActivity.this, "QR Code Generated", Toast.LENGTH_SHORT).show();
                            }

                            @Override
                            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                                String url = request.getUrl().toString();

                                if (url.contains("cashupi.com/success")) {
                                    checkOrderStatus(orderId, amount, phoneno);
                                    return true;
                                }

                                // Handle custom UPI / app URL schemes safely
                                if (url.startsWith("intent://") || url.startsWith("upi://") || url.startsWith("paytmmp://") || url.startsWith("app://") || url.startsWith("market://")) {
                                    try {
                                        Intent intent;
                                        if (url.startsWith("intent://")) {
                                            intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME);
                                        } else {
                                            intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                                        }

                                        // Check if there's an app to handle this intent
                                        if (intent.resolveActivity(getPackageManager()) != null) {
                                            startActivity(intent);
                                        } else {
                                            Toast.makeText(CashupiActivity.this, "App not installed to handle this action", Toast.LENGTH_SHORT).show();
                                        }

                                        return true;
                                    } catch (Exception e) {
                                        Log.e("WebView", "Error handling intent: " + url, e);
                                        Toast.makeText(CashupiActivity.this, "Failed to open app", Toast.LENGTH_SHORT).show();
                                        return true;
                                    }
                                }

                                // Allow normal web pages to load inside WebView
                                view.loadUrl(url);
                                return true;
                            }

                            @Override
                            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                                super.onReceivedError(view, request, error);
                                Toast.makeText(CashupiActivity.this, "Failed to load payment page", Toast.LENGTH_SHORT).show();
                            }
                        });

                        webView.loadUrl(paymentUrl);

                    } else {
                        String message = jsonResponse.getString("message");
                        Toast.makeText(CashupiActivity.this, "Failed: " + message, Toast.LENGTH_SHORT).show();
                    }
                } catch (JSONException e) {
                    Log.e("OrderApiTask", "JSON Parsing Error", e);
                    Toast.makeText(CashupiActivity.this, "Invalid response from server", Toast.LENGTH_SHORT).show();
                }
            } else {
                Toast.makeText(CashupiActivity.this, "Failed to create order", Toast.LENGTH_SHORT).show();
            }
        }
    }



    private void checkOrderStatus(String orderId, String amount, String phoneno) {
        String apiUrl = "https://cashupi.com/api/check-order-status";  // API endpoint

        // Create request payload (form-urlencoded format)
        String payload = "user_token=" + userToken + "&order_id=" + orderId;

        // Create a request body with the payload
        RequestBody formBody = RequestBody.create(MediaType.parse("application/x-www-form-urlencoded"), payload);

        // Create the HTTP request
        Request request = new Request.Builder()
                .url(apiUrl)
                .post(formBody)
                .build();

        // Use a background thread for network operations
        new Thread(() -> {
            OkHttpClient client = new OkHttpClient();
            try (okhttp3.Response response = client.newCall(request).execute()) {
                if (!response.isSuccessful()) {
                    throw new IOException("Unexpected HTTP response: " + response.code());
                }

                String responseBody = response.body().string();
                JSONObject jsonResponse = new JSONObject(responseBody);

                runOnUiThread(() -> {
                    try {
                        String status = jsonResponse.optString("status");
                        String message = jsonResponse.optString("message");

                       // Toast.makeText(this, "Status: " + status, Toast.LENGTH_SHORT).show();

                        if ("true".equals(status)) {
                            JSONObject result = jsonResponse.getJSONObject("result");
                            String txnStatus = result.optString("txnStatus");
                            String resultInfo = result.optString("resultInfo");
                            String receivedOrderId = result.optString("orderId");
                            String receivedAmount = result.optString("amount");

                            if ("SUCCESS".equals(txnStatus)) {
                               // Toast.makeText(this, "Payment Successful! Order ID: " + receivedOrderId, Toast.LENGTH_LONG).show();
                                updateWalletBalance(phoneno, Double.parseDouble(amount));
                            } else {
                                Toast.makeText(this, "Transaction failed: " + resultInfo, Toast.LENGTH_LONG).show();
                            }
                        } else {
                            Toast.makeText(this, "Order is not completed: " + message, Toast.LENGTH_LONG).show();
                        }
                    } catch (JSONException e) {
                        e.printStackTrace();
                        Toast.makeText(this, "Error parsing response: " + e.getMessage(), Toast.LENGTH_LONG).show();
                    }
                });
            } catch (IOException | JSONException e) {
                e.printStackTrace();
                runOnUiThread(() -> Toast.makeText(this, "Order status check failed: " + e.getMessage(), Toast.LENGTH_LONG).show());
            }
        }).start();

    }




    private void updateWalletBalance(String phoneno, double amount) {
        double finalCoins = currentDepo + amount;

        // Prepare the data to update
        Map<String, Object> updateData = new HashMap<>();
        updateData.put("depoBalance", finalCoins);

        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        // API Call to update the user's wallet balance
        Call<UserResponse> call = myApi.updateUser(userId, updateData);
        call.enqueue(new Callback<UserResponse>() {
            @Override
            public void onResponse(Call<UserResponse> call, Response<UserResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    if (response.body().isSuccess()) {
                        saveUsersTransactionDetails();
                        Toast.makeText(CashupiActivity.this, "Payment Successful", Toast.LENGTH_SHORT).show();
                    } else {
                        Toast.makeText(CashupiActivity.this, response.body().getMessage(), Toast.LENGTH_SHORT).show();
                    }
                } else {
                    Toast.makeText(CashupiActivity.this, "Failed to update balance", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<UserResponse> call, Throwable throwable) {
                Toast.makeText(CashupiActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }
    private void saveUsersTransactionDetails() {
        // Get user details
       long userIdLong = SharedPrefManager.getInstance(CashupiActivity.this).getUserId();
        String userId = String.valueOf(userIdLong); // Convert to String for API call
        String date = new SimpleDateFormat("dd-MM-yy", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String time = new SimpleDateFormat("HH:mm:ss", Locale.getDefault()).format(Calendar.getInstance().getTime());
        String transactionId = "TRAN" + System.currentTimeMillis();
        String inputCoin = String.valueOf(amount);

        // Initialize API Client
        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        Call<TransactionModel> call = myApi.storeUserTransaction(
                userId,
                "Deposit", // type
                email,
                inputCoin, // amount
                date,
                time,
                transactionId,
                "CashUPI", // method
                "Pending" // status
        );

        call.enqueue(new Callback<TransactionModel>() {
            @Override
            public void onResponse(Call<TransactionModel> call, Response<TransactionModel> response) {
                if (response.isSuccessful() && response.body() != null) {
                    Intent intent = new Intent(CashupiActivity.this, Add_Money_Activity.class);
                    intent.setFlags( Intent.FLAG_ACTIVITY_CLEAR_TOP );
                    startActivity(intent);
                    finish();
                    Toast.makeText(CashupiActivity.this, "Transaction Recorded Successfully", Toast.LENGTH_SHORT).show();
                } else {
                    Toast.makeText(CashupiActivity.this, "Failed to Record Transaction: " + response.message(), Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<TransactionModel> call, Throwable throwable) {
                Toast.makeText(CashupiActivity.this, "Error: " + throwable.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }


    private void loadData() {
        long userId = SharedPrefManager.getInstance(this).getUserId(); // Get userId from shared preferences
        MyApi myApi = APIClient.getApiClient(getApplicationContext()).create(MyApi.class);

        // API Call to fetch user profile data
        Call<ApiResponse> call = myApi.fetchProfileData(userId);
        call.enqueue(new Callback<ApiResponse>() {
            @Override
            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (response.isSuccessful() && response.body() != null) {
                    User model = response.body().getUser();
                    currentCoin = model.getBalance();
                    currentDepo = model.getDepoBalance();
                    phoneno = model.getPhoneno();
                    email = model.getEmail();

                } else {
                    Toast.makeText(CashupiActivity.this, "Failed to load user data", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<ApiResponse> call, Throwable throwable) {

            }
        });

    }

}
